/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.arc3d.engine.DriverBugWorkarounds;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.text.EmojiFont;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.IrisApiIntegration;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiPlatform;
import icyllis.modernui.mc.OptiFineIntegration;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.text.Typeface;
import icyllis.modernui.view.WindowManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.StringUtils;

public abstract class ModernUIClient
extends ModernUI {
    private static volatile ModernUIClient sInstance;
    private static volatile boolean sBootstrap;
    public static volatile boolean sInventoryPause;
    public static volatile boolean sRemoveTelemetrySession;
    public static volatile float sFontScale;
    public static volatile boolean sUseColorEmoji;
    public static volatile boolean sEmojiShortcodes;
    public static volatile String sFirstFontFamily;
    public static volatile List<? extends String> sFallbackFontFamilyList;
    public static volatile List<? extends String> sFontRegistrationList;
    protected volatile Typeface mTypeface;
    protected volatile FontFamily mFirstFontFamily;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getBootstrapProperties() {
        if (sBootstrap) return props;
        Class<ModernUIClient> clazz = ModernUIClient.class;
        synchronized (ModernUIClient.class) {
            if (sBootstrap) return props;
            Path path = MuiPlatform.get().getBootstrapPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(path, StandardOpenOption.READ);){
                    props.load(is);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to load bootstrap file", (Throwable)e);
                }
            } else {
                try {
                    Files.createFile(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to create bootstrap file", (Throwable)e);
                }
            }
            sBootstrap = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return props;
        }
    }

    protected ModernUIClient() {
        sInstance = this;
    }

    public static ModernUIClient getInstance() {
        return sInstance;
    }

    public static boolean areShadersEnabled() {
        if (ModernUIMod.isOptiFineLoaded() && OptiFineIntegration.isShaderPackLoaded()) {
            return true;
        }
        if (ModernUIMod.isIrisApiLoaded()) {
            return IrisApiIntegration.isShaderPackInUse();
        }
        return false;
    }

    public static String getBootstrapProperty(String key) {
        Properties props = ModernUIClient.getBootstrapProperties();
        if (props != null) {
            return props.getProperty(key);
        }
        return null;
    }

    public static void setBootstrapProperty(String key, String value) {
        Properties props = ModernUIClient.getBootstrapProperties();
        if (props != null) {
            props.setProperty(key, value);
            try (OutputStream os = Files.newOutputStream(MuiPlatform.get().getBootstrapPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                props.store(os, "Modern UI bootstrap file");
            }
            catch (IOException e) {
                LOGGER.error(MARKER, "Failed to write bootstrap file", (Throwable)e);
            }
        }
    }

    @Nullable
    public static DriverBugWorkarounds getGpuDriverBugWorkarounds() {
        Properties props = ModernUIClient.getBootstrapProperties();
        if (props != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String) {
                    String key = (String)k;
                    if (v instanceof String) {
                        Boolean state;
                        String value = (String)v;
                        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "enable".equalsIgnoreCase(value)) {
                            state = Boolean.TRUE;
                        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "disable".equalsIgnoreCase(value)) {
                            state = Boolean.FALSE;
                        } else {
                            return;
                        }
                        if (key.startsWith("arc3d_driverBugWorkarounds_")) {
                            map.put(key.substring(27), state);
                        }
                    }
                }
            }));
            if (!map.isEmpty()) {
                return new DriverBugWorkarounds(map);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void loadFonts(String first, @Nonnull Collection<String> fallbacks, @Nonnull Set<FontFamily> selected, @Nonnull Consumer<FontFamily> firstSetter, boolean firstLoad) {
        if (firstLoad) {
            ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
            FontResourceManager fontManager = FontResourceManager.getInstance();
            List<? extends String> registrationList = sFontRegistrationList;
            if (registrationList != null) {
                for (String string : new LinkedHashSet<String>(registrationList)) {
                    void var11_17;
                    File file = new File(string.replaceAll("\\\\", "/"));
                    if (file.isDirectory()) {
                        File[] fileArray = file.listFiles((dir, name) -> name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".ttc") || name.endsWith(".otc"));
                        if (fileArray == null) {
                            continue;
                        }
                    } else {
                        File[] fileArray = new File[]{file};
                    }
                    for (Iterator entry : var11_17) {
                        tasks.add(CompletableFuture.runAsync(() -> {
                            try {
                                FontFamily[] families;
                                for (FontFamily f : families = FontFamily.createFamilies(entry, true)) {
                                    fontManager.onFontRegistered(f);
                                    LOGGER.info(MARKER, "Registered font '{}', path '{}'", (Object)f.getFamilyName(), (Object)entry);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error(MARKER, "Failed to register font '{}'", (Object)entry, (Object)e);
                            }
                        }));
                    }
                }
            }
            Path directory = Minecraft.m_91087_().m_245161_();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
                for (Path path : directoryStream) {
                    String name2 = path.getFileName().toString();
                    if (!name2.endsWith(".ttf") && !name2.endsWith(".otf") && !name2.endsWith(".ttc") && !name2.endsWith(".otc")) continue;
                    Path absP = path.toAbsolutePath();
                    tasks.add(CompletableFuture.runAsync(() -> {
                        try {
                            FontFamily[] families;
                            for (FontFamily f : families = FontFamily.createFamilies(absP.toFile(), true)) {
                                fontManager.onFontRegistered(f);
                                LOGGER.info(MARKER, "Registered font '{}', path '{}'", (Object)f.getFamilyName(), (Object)absP);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(MARKER, "Failed to register font '{}'", (Object)absP, (Object)e);
                        }
                    }));
                }
            }
            catch (IOException iOException) {
                LOGGER.error(MARKER, "Failed to open resource pack directory", (Throwable)iOException);
            }
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            for (Map.Entry entry : resourceManager.m_214160_("font", res -> {
                if (res.m_135827_().equals("modernui")) {
                    String p = res.m_135815_();
                    return p.endsWith(".ttf") || p.endsWith(".otf") || p.endsWith(".ttc") || p.endsWith(".otc");
                }
                return false;
            }).entrySet()) {
                for (Resource resource : (List)entry.getValue()) {
                    tasks.add(CompletableFuture.runAsync(() -> {
                        try (InputStream inputStream = resource.m_215507_();){
                            FontFamily[] families;
                            for (FontFamily f : families = FontFamily.createFamilies(inputStream, true)) {
                                fontManager.onFontRegistered(f);
                                LOGGER.info(MARKER, "Registered font '{}', location '{}' in pack: '{}'", (Object)f.getFamilyName(), entry.getKey(), (Object)resource.m_215506_());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(MARKER, "Failed to register font '{}' in pack: '{}'", entry.getKey(), (Object)resource.m_215506_(), (Object)e);
                        }
                    }));
                }
            }
            CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
        }
        boolean success = ModernUIClient.loadSingleFont(first, selected, firstSetter);
        for (String fallback : fallbacks) {
            success &= ModernUIClient.loadSingleFont(fallback, selected, null);
        }
        if (!success && ModernUIMod.isDeveloperMode()) {
            LOGGER.debug(MARKER, "Available system font families:\n{}", (Object)String.join((CharSequence)"\n", FontFamily.getSystemFontMap().keySet()));
        }
    }

    private static boolean loadSingleFont(String value, @Nonnull Set<FontFamily> selected, @Nullable Consumer<FontFamily> firstSetter) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        try {
            File f2 = new File(value.replaceAll("\\\\", "/"));
            FontFamily family = FontFamily.createFamily(f2, false);
            selected.add(family);
            LOGGER.debug(MARKER, "Font '{}' was loaded with config value '{}' as LOCAL FILE", (Object)family.getFamilyName(), (Object)value);
            if (firstSetter != null) {
                firstSetter.accept(family);
            }
            return true;
        }
        catch (Exception f2) {
            Optional<FontFamily> optional;
            FontFamily family = FontFamily.getSystemFontWithAlias(value);
            if (family == null && (optional = FontFamily.getSystemFontMap().values().stream().filter(f -> f.getFamilyName().equalsIgnoreCase(value)).findFirst()).isPresent()) {
                family = optional.get();
            }
            if (family != null) {
                selected.add(family);
                LOGGER.debug(MARKER, "Font '{}' was loaded with config value '{}' as SYSTEM FONT", (Object)family.getFamilyName(), (Object)value);
                if (firstSetter != null) {
                    firstSetter.accept(family);
                }
                return true;
            }
            LOGGER.info(MARKER, "Font '{}' failed to load or invalid", (Object)value);
            return false;
        }
    }

    @Override
    @Nonnull
    protected Typeface onGetSelectedTypeface() {
        if (this.mTypeface != null) {
            return this.mTypeface;
        }
        return super.onGetSelectedTypeface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTypeface() {
        ModernUIClient modernUIClient = this;
        synchronized (modernUIClient) {
            if (this.mTypeface == null) {
                assert (this.mFirstFontFamily == null);
                this.mTypeface = ModernUIClient.loadTypefaceInternal(this::setFirstFontFamily, true);
                LOGGER.info(MARKER, "Loaded typeface: {}", (Object)this.mTypeface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTypeface() {
        ModernUIClient modernUIClient = this;
        synchronized (modernUIClient) {
            boolean firstLoad = this.mTypeface == null;
            this.mFirstFontFamily = null;
            this.mTypeface = ModernUIClient.loadTypefaceInternal(this::setFirstFontFamily, firstLoad);
            LOGGER.info(MARKER, "{} typeface: {}", (Object)(firstLoad ? "Loaded" : "Reloaded"), (Object)this.mTypeface);
        }
    }

    public void reloadFontStrike() {
        Minecraft.m_91087_().m_18707_(() -> FontResourceManager.getInstance().reloadAll());
    }

    @Nonnull
    private static Typeface loadTypefaceInternal(@Nonnull Consumer<FontFamily> firstSetter, boolean firstLoad) {
        EmojiFont emojiFont;
        LinkedHashSet<FontFamily> families = new LinkedHashSet<FontFamily>();
        if (sUseColorEmoji && (emojiFont = FontResourceManager.getInstance().getEmojiFont()) != null) {
            FontFamily colorEmojiFamily = new FontFamily(emojiFont);
            families.add(colorEmojiFamily);
        }
        String first = sFirstFontFamily;
        List<? extends String> configs = sFallbackFontFamilyList;
        if (first != null || configs != null) {
            LinkedHashSet<String> fallbacks = new LinkedHashSet<String>();
            if (configs != null) {
                fallbacks.addAll(configs);
            }
            if (first != null) {
                fallbacks.remove(first);
            }
            ModernUIClient.loadFonts(first, fallbacks, families, firstSetter, firstLoad);
        }
        return Typeface.createTypeface(families.toArray(new FontFamily[0]));
    }

    @Nullable
    public FontFamily getFirstFontFamily() {
        return this.mFirstFontFamily;
    }

    protected void setFirstFontFamily(FontFamily firstFontFamily) {
        this.mFirstFontFamily = firstFontFamily;
    }

    @Override
    @Nonnull
    public InputStream getResourceStream(@Nonnull String namespace, @Nonnull String path) throws IOException {
        return Minecraft.m_91087_().m_91098_().m_215595_(new ResourceLocation(namespace, path));
    }

    @Override
    @Nonnull
    public ReadableByteChannel getResourceChannel(@Nonnull String namespace, @Nonnull String path) throws IOException {
        return Channels.newChannel(this.getResourceStream(namespace, path));
    }

    @Override
    public WindowManager getWindowManager() {
        return UIManager.getInstance().getDecorView();
    }

    static {
        sFontScale = 1.0f;
        sEmojiShortcodes = true;
    }
}

